/*
 * Decompiled with CFR 0.152.
 */
package com.vng.zalo.miniapp.openapi.sdk.client;

import com.google.gson.JsonObject;
import com.vng.zalo.miniapp.openapi.sdk.common.EndPoint;
import com.vng.zalo.miniapp.openapi.sdk.models.StatsRequest;
import com.vng.zalo.miniapp.openapi.sdk.models.StatsResponse;
import com.vng.zalo.miniapp.openapi.sdk.models.StatsType;
import com.vng.zalo.miniapp.openapi.sdk.utils.JsonUtils;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.HashMap;
import java.util.Map;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.HttpMessage;
import org.apache.http.StatusLine;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.entity.mime.MultipartEntityBuilder;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.util.EntityUtils;

class BaseClient {
    protected static final String SDK_SOURCE = "Java-2.3.2";
    protected boolean isUseProxy = false;
    protected final int CONNECTION_TIMEOUT = 2000;
    protected final int READ_TIMEOUT = 15000;
    protected RequestConfig config = null;
    protected String version;
    protected String apiKey;
    protected String apiKeyHeaderName;
    protected String identityHeaderName;
    protected String identity;

    protected String getApiKeyBearer() {
        return "Bearer " + this.apiKey;
    }

    protected boolean isPartner() {
        return this.version != null && this.version.equals("/partners");
    }

    protected void headerValidation() {
        if (this.apiKey == null || this.apiKey.isEmpty()) {
            throw new IllegalArgumentException(this.apiKeyHeaderName + " should not be blank");
        }
        if (this.identity == null || this.identity.isEmpty()) {
            throw new IllegalArgumentException(this.identityHeaderName + " should not be blank");
        }
    }

    protected BaseClient(String version, String apiKeyHeaderName, String apiKey, String identityHeaderName, String identity) {
        this.version = version;
        this.apiKeyHeaderName = apiKeyHeaderName;
        this.apiKey = apiKey;
        this.identityHeaderName = identityHeaderName;
        this.identity = identity;
    }

    protected String getBaseUrl(Long appId, String path, int ... pathVariables) {
        StringBuilder url = new StringBuilder(EndPoint.BASE_URL);
        if (this.version != null && !this.version.isEmpty()) {
            url.append(this.version);
        }
        url.append(EndPoint.APPS);
        if (appId != null) {
            url.append("/").append(appId);
        }
        if (path != null && !path.isEmpty()) {
            url.append(path);
        }
        for (int pathVar : pathVariables) {
            url.append("/").append(pathVar);
        }
        return url.toString();
    }

    public void setProxy(String host, int port) {
        if (host == null || host.isEmpty() || port < 0) {
            this.isUseProxy = false;
            this.config = null;
            return;
        }
        this.isUseProxy = true;
        HttpHost proxy = new HttpHost(host, port);
        this.config = RequestConfig.custom().setSocketTimeout(17000).setConnectTimeout(2000).setConnectionRequestTimeout(15000).setProxy(proxy).build();
    }

    protected String sendHttpGetRequest(String endpointUrl, Map<String, String> params, Map<String, String> headers) throws Exception {
        try (CloseableHttpClient httpclient = HttpClients.createDefault();){
            String string;
            block15: {
                URIBuilder builder = new URIBuilder(endpointUrl);
                if (params != null) {
                    for (Map.Entry<String, String> entry : params.entrySet()) {
                        builder.addParameter(entry.getKey(), entry.getValue());
                    }
                }
                HttpGet httpGet = new HttpGet(builder.toString());
                if (this.isUseProxy) {
                    httpGet.setConfig(this.config);
                }
                this.addHeaders(httpGet, headers);
                CloseableHttpResponse response = httpclient.execute(httpGet);
                try {
                    HttpEntity entity = response.getEntity();
                    String rs = EntityUtils.toString(entity);
                    StatusLine statusLine = response.getStatusLine();
                    string = rs;
                    if (response == null) break block15;
                }
                catch (Throwable throwable) {
                    if (response != null) {
                        try {
                            response.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                response.close();
            }
            return string;
        }
    }

    protected String sendHttpPostRequest(String endpointUrl, Map<String, String> params, JsonObject data, Map<String, String> headers) throws Exception {
        try (CloseableHttpClient httpclient = HttpClients.createDefault();){
            String string;
            block16: {
                URIBuilder builder = new URIBuilder(endpointUrl);
                if (params != null) {
                    for (Map.Entry<String, String> entry : params.entrySet()) {
                        builder.addParameter(entry.getKey(), entry.getValue());
                    }
                }
                HttpPost httpPost = new HttpPost(builder.toString());
                if (this.isUseProxy) {
                    httpPost.setConfig(this.config);
                }
                this.addHeaders(httpPost, headers);
                if (data != null) {
                    httpPost.setEntity(new StringEntity(data.toString(), ContentType.APPLICATION_JSON));
                }
                CloseableHttpResponse response = httpclient.execute(httpPost);
                try {
                    HttpEntity entity = response.getEntity();
                    string = EntityUtils.toString(entity);
                    if (response == null) break block16;
                }
                catch (Throwable throwable) {
                    if (response != null) {
                        try {
                            response.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                response.close();
            }
            return string;
        }
    }

    protected String sendHttpPutRequest(String endpointUrl, Map<String, String> params, JsonObject data, Map<String, String> headers) throws Exception {
        try (CloseableHttpClient httpclient = HttpClients.createDefault();){
            String string;
            block16: {
                URIBuilder builder = new URIBuilder(endpointUrl);
                if (params != null) {
                    for (Map.Entry<String, String> entry : params.entrySet()) {
                        builder.addParameter(entry.getKey(), entry.getValue());
                    }
                }
                HttpPut httpPut = new HttpPut(builder.toString());
                if (this.isUseProxy) {
                    httpPut.setConfig(this.config);
                }
                this.addHeaders(httpPut, headers);
                if (data != null) {
                    httpPut.setEntity(new StringEntity(data.toString(), ContentType.APPLICATION_JSON));
                }
                CloseableHttpResponse response = httpclient.execute(httpPut);
                try {
                    HttpEntity entity = response.getEntity();
                    string = EntityUtils.toString(entity);
                    if (response == null) break block16;
                }
                catch (Throwable throwable) {
                    if (response != null) {
                        try {
                            response.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                response.close();
            }
            return string;
        }
    }

    protected String sendHttpUploadRequest(String endpointUrl, Map<String, File> files, Map<String, String> params, Map<String, String> headers) throws Exception {
        try (CloseableHttpClient httpClient = HttpClients.createDefault();){
            String string;
            block16: {
                URIBuilder builder = new URIBuilder(endpointUrl);
                if (params != null) {
                    for (Map.Entry<String, String> entry : params.entrySet()) {
                        builder.addParameter(entry.getKey(), entry.getValue());
                    }
                }
                HttpPost uploadFile = new HttpPost(builder.toString());
                if (this.isUseProxy) {
                    uploadFile.setConfig(this.config);
                }
                this.addHeaders(uploadFile, headers);
                MultipartEntityBuilder entityBuilder = MultipartEntityBuilder.create();
                for (String key : files.keySet()) {
                    File value = files.getOrDefault(key, null);
                    if (value == null) continue;
                    entityBuilder.addBinaryBody(key, Files.newInputStream(value.toPath(), new OpenOption[0]), ContentType.MULTIPART_FORM_DATA, value.getName());
                }
                HttpEntity multipart = entityBuilder.build();
                uploadFile.setEntity(multipart);
                CloseableHttpResponse response = httpClient.execute(uploadFile);
                try {
                    HttpEntity entity = response.getEntity();
                    string = EntityUtils.toString(entity);
                    if (response == null) break block16;
                }
                catch (Throwable throwable) {
                    if (response != null) {
                        try {
                            response.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                response.close();
            }
            return string;
        }
    }

    protected String sendHttpUploadByteRequest(String endpointUrl, Map<String, byte[]> files, Map<String, String> params, Map<String, String> headers) throws Exception {
        try (CloseableHttpClient httpClient = HttpClients.createDefault();){
            String string;
            block19: {
                Object value;
                String key;
                URIBuilder builder = new URIBuilder(endpointUrl);
                HttpPost uploadFile = new HttpPost(builder.toString());
                if (this.isUseProxy) {
                    uploadFile.setConfig(this.config);
                }
                this.addHeaders(uploadFile, headers);
                MultipartEntityBuilder entityBuilder = MultipartEntityBuilder.create();
                HashMap<String, Object> textParams = new HashMap<String, Object>();
                if (params != null) {
                    for (Map.Entry<String, String> entry : params.entrySet()) {
                        key = entry.getKey();
                        value = entry.getValue();
                        if ("documentFiles".equals(key)) {
                            entityBuilder.addTextBody(key, (String)value, ContentType.APPLICATION_JSON);
                            continue;
                        }
                        if (key.endsWith("_Meta")) {
                            entityBuilder.addTextBody(key, (String)value, ContentType.create(ContentType.TEXT_PLAIN.getMimeType(), StandardCharsets.UTF_8));
                            continue;
                        }
                        textParams.put(key, value);
                    }
                }
                if (files != null) {
                    for (Map.Entry<String, String> entry : files.entrySet()) {
                        key = entry.getKey();
                        value = (byte[])entry.getValue();
                        if (value == null) continue;
                        String filename = textParams.getOrDefault(key, key);
                        ContentType contentType = this.getContentTypeFromFilename(filename);
                        if (!key.startsWith("ownerDocumentFiles")) continue;
                        entityBuilder.addBinaryBody("ownerDocumentFiles", new ByteArrayInputStream((byte[])value), contentType, filename);
                    }
                }
                HttpEntity multipart = entityBuilder.build();
                uploadFile.setEntity(multipart);
                CloseableHttpResponse closeableHttpResponse = httpClient.execute(uploadFile);
                try {
                    HttpEntity entity = closeableHttpResponse.getEntity();
                    string = EntityUtils.toString(entity);
                    if (closeableHttpResponse == null) break block19;
                }
                catch (Throwable throwable) {
                    if (closeableHttpResponse != null) {
                        try {
                            closeableHttpResponse.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                closeableHttpResponse.close();
            }
            return string;
        }
    }

    private ContentType getContentTypeFromFilename(String filename) {
        if (filename == null || filename.isEmpty()) {
            return ContentType.APPLICATION_OCTET_STREAM;
        }
        String lower = filename.toLowerCase();
        if (lower.endsWith(".pdf")) {
            return ContentType.create("application/pdf");
        }
        if (lower.endsWith(".png")) {
            return ContentType.create("image/png");
        }
        if (lower.endsWith(".jpg") || lower.endsWith(".jpeg")) {
            return ContentType.create("image/jpeg");
        }
        if (lower.endsWith(".gif")) {
            return ContentType.create("image/gif");
        }
        if (lower.endsWith(".zip")) {
            return ContentType.create("application/zip");
        }
        return ContentType.APPLICATION_OCTET_STREAM;
    }

    private void addHeaders(HttpMessage httpMessage, Map<String, String> headers) {
        if (headers != null) {
            for (Map.Entry<String, String> entry : headers.entrySet()) {
                httpMessage.addHeader(entry.getKey(), entry.getValue());
            }
        }
        httpMessage.addHeader(this.apiKeyHeaderName, this.getApiKeyBearer());
        httpMessage.addHeader(this.identityHeaderName, this.identity);
        httpMessage.addHeader("x-sdk-source", SDK_SOURCE);
    }

    protected String sendMultipartRequest(String endPoint, Map<String, Object> formData, Map<String, String> params, Map<String, String> headers) throws Exception {
        try (CloseableHttpClient httpClient = HttpClients.createDefault();){
            String string;
            block17: {
                URIBuilder builder = new URIBuilder(endPoint);
                if (params != null) {
                    for (Map.Entry<String, String> entry : params.entrySet()) {
                        builder.addParameter(entry.getKey(), entry.getValue());
                    }
                }
                HttpPost post = new HttpPost(builder.toString());
                if (this.isUseProxy) {
                    post.setConfig(this.config);
                }
                this.addHeaders(post, headers);
                MultipartEntityBuilder entityBuilder = MultipartEntityBuilder.create();
                for (String key : formData.keySet()) {
                    Object value = formData.getOrDefault(key, null);
                    if (value == null) continue;
                    if (value instanceof File) {
                        File file = (File)value;
                        entityBuilder.addBinaryBody(key, Files.newInputStream(file.toPath(), new OpenOption[0]), ContentType.MULTIPART_FORM_DATA, file.getName());
                        continue;
                    }
                    entityBuilder.addTextBody(key, value.toString(), ContentType.create(ContentType.TEXT_PLAIN.getMimeType(), StandardCharsets.UTF_8));
                }
                HttpEntity multipart = entityBuilder.build();
                post.setEntity(multipart);
                CloseableHttpResponse response = httpClient.execute(post);
                try {
                    HttpEntity entity = response.getEntity();
                    string = EntityUtils.toString(entity);
                    if (response == null) break block17;
                }
                catch (Throwable throwable) {
                    if (response != null) {
                        try {
                            response.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                response.close();
            }
            return string;
        }
    }

    protected String sendMultipartPutRequest(String endpointUrl, Map<String, String> params, Map<String, Object> formData, Map<String, String> headers) throws Exception {
        try (CloseableHttpClient httpclient = HttpClients.createDefault();){
            String string;
            block17: {
                URIBuilder builder = new URIBuilder(endpointUrl);
                if (params != null) {
                    for (Map.Entry<String, String> entry : params.entrySet()) {
                        builder.addParameter(entry.getKey(), entry.getValue());
                    }
                }
                HttpPut httpPut = new HttpPut(builder.toString());
                if (this.isUseProxy) {
                    httpPut.setConfig(this.config);
                }
                this.addHeaders(httpPut, headers);
                MultipartEntityBuilder entityBuilder = MultipartEntityBuilder.create();
                for (String key : formData.keySet()) {
                    Object value = formData.getOrDefault(key, null);
                    if (value == null) continue;
                    if (value instanceof File) {
                        File file = (File)value;
                        entityBuilder.addBinaryBody(key, Files.newInputStream(file.toPath(), new OpenOption[0]), ContentType.MULTIPART_FORM_DATA, file.getName());
                        continue;
                    }
                    entityBuilder.addTextBody(key, value.toString(), ContentType.create(ContentType.TEXT_PLAIN.getMimeType(), StandardCharsets.UTF_8));
                }
                HttpEntity multipart = entityBuilder.build();
                httpPut.setEntity(multipart);
                CloseableHttpResponse response = httpclient.execute(httpPut);
                try {
                    HttpEntity entity = response.getEntity();
                    string = EntityUtils.toString(entity);
                    if (response == null) break block17;
                }
                catch (Throwable throwable) {
                    if (response != null) {
                        try {
                            response.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                response.close();
            }
            return string;
        }
    }

    public StatsResponse getStats(StatsRequest request) throws Exception {
        this.headerValidation();
        if (request.getType() == null) {
            throw new IllegalArgumentException("StatsType should not be blank");
        }
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("type", request.getType().getName());
        params.put("startTime", String.valueOf(request.getStartTime()));
        params.put("endTime", String.valueOf(request.getEndTime()));
        if (request.getType().equals((Object)StatsType.ACCESS_TRAFFIC)) {
            params.putAll(request.getAdditionalParams());
        }
        if (request.getType().equals((Object)StatsType.ZDN)) {
            params.put("step", String.valueOf(request.getStep()));
        }
        String responseString = this.sendHttpGetRequest(this.getBaseUrl(request.getMiniAppId(), EndPoint.GET_STATS, new int[0]), params, null);
        JsonObject jsonObject = JsonUtils.fromJson(responseString, JsonObject.class);
        StatsResponse response = new StatsResponse();
        response.setError(jsonObject.get("err").getAsInt());
        response.setMessage(jsonObject.get("msg").getAsString());
        if (response.getError() == 0) {
            JsonObject data = jsonObject.getAsJsonObject("data");
            response.setData(data);
        }
        return response;
    }
}

