/*
 * Decompiled with CFR 0.152.
 */
package com.vng.zalo.miniapp.openapi.sdk.client;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.vng.zalo.miniapp.openapi.sdk.client.BaseClient;
import com.vng.zalo.miniapp.openapi.sdk.common.EndPoint;
import com.vng.zalo.miniapp.openapi.sdk.enums.BusinessType;
import com.vng.zalo.miniapp.openapi.sdk.enums.PaymentMethod;
import com.vng.zalo.miniapp.openapi.sdk.models.AppCategory;
import com.vng.zalo.miniapp.openapi.sdk.models.AppInfo;
import com.vng.zalo.miniapp.openapi.sdk.models.AppPermission;
import com.vng.zalo.miniapp.openapi.sdk.models.AppVersion;
import com.vng.zalo.miniapp.openapi.sdk.models.CancelRequestPublishMiniAppRequest;
import com.vng.zalo.miniapp.openapi.sdk.models.CancelRequestPublishMiniAppResponse;
import com.vng.zalo.miniapp.openapi.sdk.models.CreateMiniAppRequest;
import com.vng.zalo.miniapp.openapi.sdk.models.CreateMiniAppResponse;
import com.vng.zalo.miniapp.openapi.sdk.models.CreatePaymentChannelResponse;
import com.vng.zalo.miniapp.openapi.sdk.models.CreateQRCodeShortUrlRequest;
import com.vng.zalo.miniapp.openapi.sdk.models.CreateQRCodeShortUrlResponse;
import com.vng.zalo.miniapp.openapi.sdk.models.DeployMiniAppRequest;
import com.vng.zalo.miniapp.openapi.sdk.models.DeployMiniAppResponse;
import com.vng.zalo.miniapp.openapi.sdk.models.ListCategoriesResponse;
import com.vng.zalo.miniapp.openapi.sdk.models.ListMiniAppsRequest;
import com.vng.zalo.miniapp.openapi.sdk.models.ListMiniAppsResponse;
import com.vng.zalo.miniapp.openapi.sdk.models.ListPaymentChannelRequest;
import com.vng.zalo.miniapp.openapi.sdk.models.ListPaymentChannelResponse;
import com.vng.zalo.miniapp.openapi.sdk.models.ListPermitsRequest;
import com.vng.zalo.miniapp.openapi.sdk.models.ListPermitsResponse;
import com.vng.zalo.miniapp.openapi.sdk.models.ListQRCodeShortLinkRequest;
import com.vng.zalo.miniapp.openapi.sdk.models.ListQRCodeShortLinkResponse;
import com.vng.zalo.miniapp.openapi.sdk.models.ListVersionsRequest;
import com.vng.zalo.miniapp.openapi.sdk.models.ListVersionsResponse;
import com.vng.zalo.miniapp.openapi.sdk.models.PaymentChannel;
import com.vng.zalo.miniapp.openapi.sdk.models.PaymentSettingRequest;
import com.vng.zalo.miniapp.openapi.sdk.models.PaymentSettingResponse;
import com.vng.zalo.miniapp.openapi.sdk.models.PublishMiniAppRequest;
import com.vng.zalo.miniapp.openapi.sdk.models.PublishMiniAppResponse;
import com.vng.zalo.miniapp.openapi.sdk.models.RequestPermissionRequest;
import com.vng.zalo.miniapp.openapi.sdk.models.RequestPermissionResponse;
import com.vng.zalo.miniapp.openapi.sdk.models.RequestPublishMiniAppRequest;
import com.vng.zalo.miniapp.openapi.sdk.models.RequestPublishMiniAppResponse;
import com.vng.zalo.miniapp.openapi.sdk.models.UpdatePaymentChannelResponse;
import com.vng.zalo.miniapp.openapi.sdk.models.UpdatePaymentSettingRequest;
import com.vng.zalo.miniapp.openapi.sdk.models.UpdatePaymentSettingResponse;
import com.vng.zalo.miniapp.openapi.sdk.models.apidomain.request.CreateApiDomainRequest;
import com.vng.zalo.miniapp.openapi.sdk.models.apidomain.request.ListApiDomainRequest;
import com.vng.zalo.miniapp.openapi.sdk.models.apidomain.request.UpdateApiDomainRequest;
import com.vng.zalo.miniapp.openapi.sdk.models.apidomain.response.CreateApiDomainResponse;
import com.vng.zalo.miniapp.openapi.sdk.models.apidomain.response.ListApiDomainResponse;
import com.vng.zalo.miniapp.openapi.sdk.models.apidomain.response.UpdateApiDomainResponse;
import com.vng.zalo.miniapp.openapi.sdk.models.apps.request.AppInfoRequest;
import com.vng.zalo.miniapp.openapi.sdk.models.apps.request.BusinessProfileRequest;
import com.vng.zalo.miniapp.openapi.sdk.models.apps.request.UpdateAppCategoryRequest;
import com.vng.zalo.miniapp.openapi.sdk.models.apps.request.UpdateBusinessProfileRequest;
import com.vng.zalo.miniapp.openapi.sdk.models.apps.request.ValidateNameRequest;
import com.vng.zalo.miniapp.openapi.sdk.models.apps.request.ValidateOARequest;
import com.vng.zalo.miniapp.openapi.sdk.models.apps.response.AppInfoResponse;
import com.vng.zalo.miniapp.openapi.sdk.models.apps.response.BusinessProfileResponse;
import com.vng.zalo.miniapp.openapi.sdk.models.apps.response.UpdateAppCategoryResponse;
import com.vng.zalo.miniapp.openapi.sdk.models.apps.response.UpdateBusinessProfileResponse;
import com.vng.zalo.miniapp.openapi.sdk.models.apps.response.ValidateNameResponse;
import com.vng.zalo.miniapp.openapi.sdk.models.apps.response.ValidateOAResponse;
import com.vng.zalo.miniapp.openapi.sdk.models.documents.DocumentFile;
import com.vng.zalo.miniapp.openapi.sdk.models.documents.DocumentInfo;
import com.vng.zalo.miniapp.openapi.sdk.models.documents.request.DocumentsRequest;
import com.vng.zalo.miniapp.openapi.sdk.models.documents.request.SubmitBusinessDocumentsRequest;
import com.vng.zalo.miniapp.openapi.sdk.models.documents.request.SubmitOwnerDocumentsRequest;
import com.vng.zalo.miniapp.openapi.sdk.models.documents.request.UploadDocumentFileRequest;
import com.vng.zalo.miniapp.openapi.sdk.models.documents.request.VerifyOARequest;
import com.vng.zalo.miniapp.openapi.sdk.models.documents.response.DocumentsResponse;
import com.vng.zalo.miniapp.openapi.sdk.models.documents.response.SubmitBusinessDocumentsResponse;
import com.vng.zalo.miniapp.openapi.sdk.models.documents.response.SubmitOwnerDocumentsResponse;
import com.vng.zalo.miniapp.openapi.sdk.models.documents.response.UploadDocumentFileResponse;
import com.vng.zalo.miniapp.openapi.sdk.models.documents.response.VerifyOAResponse;
import com.vng.zalo.miniapp.openapi.sdk.models.payment.CustomPaymentChannel;
import com.vng.zalo.miniapp.openapi.sdk.models.payment.PaymentChannelRequest;
import com.vng.zalo.miniapp.openapi.sdk.models.payment.responses.BankPaymentChannelResp;
import com.vng.zalo.miniapp.openapi.sdk.models.payment.responses.CODPaymentChannelResp;
import com.vng.zalo.miniapp.openapi.sdk.models.payment.responses.CustomPaymentChannelResp;
import com.vng.zalo.miniapp.openapi.sdk.models.payment.responses.MoMoPaymentChannelResp;
import com.vng.zalo.miniapp.openapi.sdk.models.payment.responses.PayMEPaymentChannelResp;
import com.vng.zalo.miniapp.openapi.sdk.models.payment.responses.VNPayPaymentChannelResp;
import com.vng.zalo.miniapp.openapi.sdk.models.payment.responses.ZaloPayPaymentChannelResp;
import com.vng.zalo.miniapp.openapi.sdk.utils.JsonUtils;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public class PartnerClient
extends BaseClient {
    public PartnerClient(String partnerApiKey, String partnerId) {
        super("/partners", "X-Partner-Api-Key", partnerApiKey, "X-Partner-Id", partnerId);
        if (partnerApiKey == null || partnerApiKey.isEmpty() || partnerId == null || partnerId.isEmpty()) {
            throw new IllegalArgumentException("partnerApiKey and partnerId should not be blank");
        }
    }

    public ListMiniAppsResponse listMiniApps(ListMiniAppsRequest request) throws Exception {
        this.headerValidation();
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("offset", String.valueOf(request.getOffset()));
        params.put("limit", String.valueOf(request.getLimit()));
        if (this.isPartner() && request.getZaloAppId() != null && !request.getZaloAppId().isEmpty()) {
            params.put("zaloAppId", request.getZaloAppId());
        }
        String responseString = this.sendHttpGetRequest(this.getBaseUrl(null, null, new int[0]), params, null);
        JsonObject jsonObject = JsonUtils.fromJson(responseString, JsonObject.class);
        ListMiniAppsResponse response = new ListMiniAppsResponse();
        response.setError(jsonObject.get("err").getAsInt());
        response.setMessage(jsonObject.get("msg").getAsString());
        if (response.getError() == 0) {
            JsonObject data = jsonObject.getAsJsonObject("data");
            response.setTotal(data.get("total").getAsInt());
            response.setApps(JsonUtils.fromJSONArray(data.getAsJsonArray("apps"), AppInfo.class));
        }
        return response;
    }

    public ListCategoriesResponse listCategories() throws Exception {
        return this.listCategories((String)null);
    }

    public ListCategoriesResponse listCategories(BusinessType businessType) throws Exception {
        return this.listCategories(businessType != null ? businessType.getValue() : null);
    }

    public ListCategoriesResponse listCategories(String businessType) throws Exception {
        this.headerValidation();
        HashMap<String, String> params = new HashMap<String, String>();
        if (businessType != null && !businessType.isEmpty()) {
            params.put("businessType", businessType);
        }
        String responseString = this.sendHttpGetRequest(this.getBaseUrl(null, "/categories", new int[0]), params, null);
        JsonObject jsonObject = JsonUtils.fromJson(responseString, JsonObject.class);
        ListCategoriesResponse response = new ListCategoriesResponse();
        response.setError(jsonObject.get("err").getAsInt());
        response.setMessage(jsonObject.get("msg").getAsString());
        if (response.getError() == 0) {
            JsonObject data = jsonObject.getAsJsonObject("data");
            response.setCategories(JsonUtils.fromJSONArray(data.getAsJsonArray("categories"), AppCategory.class));
            response.setTotal(response.getCategories().size());
        }
        return response;
    }

    public CreateMiniAppResponse createMiniApp(CreateMiniAppRequest request) throws Exception {
        this.headerValidation();
        JsonObject data = new JsonObject();
        data.addProperty("appName", request.getAppName());
        data.addProperty("appDescription", request.getAppDescription());
        data.addProperty("appCategory", request.getAppCategory());
        data.addProperty("appLogoUrl", request.getAppLogoUrl());
        data.addProperty("coverUrl", request.getCoverUrl());
        data.addProperty("browsable", String.valueOf(request.isBrowsable()));
        if (request.getSubCateIds() != null && !request.getSubCateIds().isEmpty()) {
            ArrayList<String> subCateIdStrings = new ArrayList<String>();
            for (Integer id : request.getSubCateIds()) {
                subCateIdStrings.add(String.valueOf(id));
            }
            data.addProperty("subCateIds", String.join((CharSequence)",", subCateIdStrings));
        }
        if (this.isPartner() && request.getZaloAppId() != null && !request.getZaloAppId().isEmpty()) {
            data.addProperty("zaloAppId", request.getZaloAppId());
        }
        if (this.isPartner() && request.getTypeOfBusiness() != null && !request.getTypeOfBusiness().isEmpty()) {
            data.addProperty("typeOfBusiness", request.getTypeOfBusiness());
        }
        String responseString = this.sendHttpPostRequest(this.getBaseUrl(null, null, new int[0]), null, data, null);
        JsonObject jsonObject = JsonUtils.fromJson(responseString, JsonObject.class);
        CreateMiniAppResponse response = new CreateMiniAppResponse();
        response.setError(jsonObject.get("err").getAsInt());
        response.setMessage(jsonObject.get("msg").getAsString());
        if (response.getError() == 0) {
            JsonObject dataResponse = jsonObject.getAsJsonObject("data");
            if (dataResponse.has("appId")) {
                response.setAppId(dataResponse.get("appId").getAsString());
            }
            if (dataResponse.has("appName")) {
                response.setAppName(dataResponse.get("appName").getAsString());
            }
            if (dataResponse.has("zaloAppId")) {
                response.setZaloAppId(dataResponse.get("zaloAppId").getAsString());
            }
            if (dataResponse.has("appLogoUrl")) {
                response.setAppLogoUrl(dataResponse.get("appLogoUrl").getAsString());
            }
        }
        return response;
    }

    public DeployMiniAppResponse deployMiniApp(DeployMiniAppRequest request) throws Exception {
        this.headerValidation();
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("name", request.getName());
        params.put("description", request.getDescription());
        HashMap<String, File> files = new HashMap<String, File>();
        files.put("file", request.getFile());
        String baseUrl = this.getBaseUrl(request.getMiniAppId(), "/upload", new int[0]);
        String responseString = this.sendHttpUploadRequest(baseUrl, files, params, null);
        JsonObject jsonObject = JsonUtils.fromJson(responseString, JsonObject.class);
        DeployMiniAppResponse response = new DeployMiniAppResponse();
        response.setError(jsonObject.get("err").getAsInt());
        response.setMessage(jsonObject.get("msg").getAsString());
        if (response.getError() == 0) {
            JsonObject data = jsonObject.getAsJsonObject("data");
            if (data.has("versionId")) {
                response.setVersionId(data.get("versionId").getAsString());
            }
            if (data.has("entrypoint")) {
                response.setEntrypoint(data.get("entrypoint").getAsString());
            }
        }
        return response;
    }

    public ListVersionsResponse listVersionsMiniApp(ListVersionsRequest request) throws Exception {
        this.headerValidation();
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("offset", String.valueOf(request.getOffset()));
        params.put("limit", String.valueOf(request.getLimit()));
        String responseString = this.sendHttpGetRequest(this.getBaseUrl(request.getMiniAppId(), EndPoint.LIST_VERSION_MINI_APP, new int[0]), params, null);
        JsonObject jsonObject = JsonUtils.fromJson(responseString, JsonObject.class);
        ListVersionsResponse response = new ListVersionsResponse();
        response.setError(jsonObject.get("err").getAsInt());
        response.setMessage(jsonObject.get("msg").getAsString());
        if (response.getError() == 0) {
            JsonObject data = jsonObject.getAsJsonObject("data");
            response.setTotal(data.get("total").getAsInt());
            response.setVersions(JsonUtils.fromJSONArray(data.getAsJsonArray("versions"), AppVersion.class));
        }
        return response;
    }

    public RequestPublishMiniAppResponse requestPublishMiniApp(RequestPublishMiniAppRequest request) throws Exception {
        this.headerValidation();
        JsonObject data = new JsonObject();
        data.addProperty("versionId", String.valueOf(request.getVersionId()));
        data.addProperty("description", request.getDescription());
        String responseString = this.sendHttpPostRequest(this.getBaseUrl(request.getMiniAppId(), EndPoint.REQUEST_PUBLISH_MINI_APP, new int[0]), null, data, null);
        JsonObject jsonObject = JsonUtils.fromJson(responseString, JsonObject.class);
        RequestPublishMiniAppResponse response = new RequestPublishMiniAppResponse();
        response.setError(jsonObject.get("err").getAsInt());
        response.setMessage(jsonObject.get("msg").getAsString());
        return response;
    }

    public PublishMiniAppResponse publishMiniApp(PublishMiniAppRequest request) throws Exception {
        this.headerValidation();
        JsonObject data = new JsonObject();
        data.addProperty("versionId", String.valueOf(request.getVersionId()));
        String responseString = this.sendHttpPostRequest(this.getBaseUrl(request.getMiniAppId(), EndPoint.PUBLISH_MINI_APP, new int[0]), null, data, null);
        JsonObject jsonObject = JsonUtils.fromJson(responseString, JsonObject.class);
        PublishMiniAppResponse response = new PublishMiniAppResponse();
        response.setError(jsonObject.get("err").getAsInt());
        response.setMessage(jsonObject.get("msg").getAsString());
        return response;
    }

    public CancelRequestPublishMiniAppResponse cancelRequestPublishMiniApp(CancelRequestPublishMiniAppRequest request) throws Exception {
        this.headerValidation();
        JsonObject data = new JsonObject();
        String responseString = this.sendHttpPostRequest(this.getBaseUrl(request.getMiniAppId(), "/cancel-request-publish", new int[0]), null, data, null);
        JsonObject jsonObject = JsonUtils.fromJson(responseString, JsonObject.class);
        CancelRequestPublishMiniAppResponse response = new CancelRequestPublishMiniAppResponse();
        response.setError(jsonObject.get("err").getAsInt());
        response.setMessage(jsonObject.get("msg").getAsString());
        return response;
    }

    public RequestPermissionResponse requestPermission(RequestPermissionRequest request) throws Exception {
        this.headerValidation();
        JsonObject data = new JsonObject();
        JsonArray permissions = new JsonArray();
        for (AppPermission permission : request.getPermissions()) {
            JsonObject permissionObject = new JsonObject();
            permissionObject.addProperty("permissionId", permission.getPermissionId());
            permissionObject.addProperty("consentText", permission.getConsentText());
            permissions.add(permissionObject);
        }
        data.add("permissions", permissions);
        data.addProperty("note", request.getNote());
        String responseString = this.sendHttpPostRequest(this.getBaseUrl(request.getMiniAppId(), EndPoint.REQUEST_PERMISSION, new int[0]), null, data, null);
        JsonObject jsonObject = JsonUtils.fromJson(responseString, JsonObject.class);
        RequestPermissionResponse response = new RequestPermissionResponse();
        response.setError(jsonObject.get("err").getAsInt());
        response.setMessage(jsonObject.get("msg").getAsString());
        if (response.getError() == 0) {
            JsonObject dataResponse = jsonObject.getAsJsonObject("data");
            response.setSuccessPermissionIds(JsonUtils.fromJSONArray(dataResponse.getAsJsonArray("successPermissions"), Integer.class));
        }
        return response;
    }

    public ListPaymentChannelResponse listPaymentChannels(ListPaymentChannelRequest request) throws Exception {
        this.headerValidation();
        if (request.getMiniAppId() <= 0L) {
            throw new IllegalArgumentException("miniAppId is invalid");
        }
        String rsp = this.sendHttpGetRequest(this.getBaseUrl(request.getMiniAppId(), EndPoint.PAYMENT_CHANNELS, new int[0]), null, null);
        JsonObject jsonObject = JsonUtils.fromJson(rsp, JsonObject.class);
        ListPaymentChannelResponse response = new ListPaymentChannelResponse();
        response.setError(jsonObject.get("err").getAsInt());
        response.setMessage(jsonObject.get("msg").getAsString());
        if (response.getError() == 0) {
            JsonObject dataResponse = jsonObject.getAsJsonObject("data");
            JsonArray arr = dataResponse.getAsJsonArray("paymentChannels");
            ArrayList<PaymentChannel> paymentChannels = new ArrayList<PaymentChannel>();
            for (JsonElement element : arr) {
                String methodStr = element.getAsJsonObject().get("method").getAsString();
                Class<? extends PaymentChannel> clazz = PartnerClient.getCLazz(methodStr);
                PaymentChannel channel = JsonUtils.fromJson(element.toString(), clazz);
                paymentChannels.add(channel);
            }
            ListPaymentChannelResponse.Data data = new ListPaymentChannelResponse.Data();
            data.setPaymentChannels(paymentChannels);
            response.setData(data);
        }
        return response;
    }

    private static Class<? extends PaymentChannel> getCLazz(String methodStr) {
        PaymentMethod method = PaymentMethod.valueOf(methodStr);
        Class clazz = null;
        switch (method) {
            case ZALOPAY: 
            case ZALOPAY_SANDBOX: 
            case CC: 
            case CC_SANDBOX: 
            case ATM: 
            case ATM_SANDBOX: {
                clazz = ZaloPayPaymentChannelResp.class;
                break;
            }
            case MOMO: 
            case MOMO_SANDBOX: {
                clazz = MoMoPaymentChannelResp.class;
                break;
            }
            case PAYME_CC: 
            case PAYME_CC_SANDBOX: 
            case PAYME_ATM: 
            case PAYME_ATM_SANDBOX: {
                clazz = PayMEPaymentChannelResp.class;
                break;
            }
            case COD: 
            case COD_SANDBOX: {
                clazz = CODPaymentChannelResp.class;
                break;
            }
            case BANK: 
            case BANK_SANDBOX: {
                clazz = BankPaymentChannelResp.class;
                break;
            }
            case VNPAY: 
            case VNPAY_SANDBOX: {
                clazz = VNPayPaymentChannelResp.class;
                break;
            }
            case CUSTOM: {
                clazz = CustomPaymentChannelResp.class;
            }
        }
        if (clazz == null) {
            throw new IllegalArgumentException("Payment method not found");
        }
        return clazz;
    }

    public CreatePaymentChannelResponse createPaymentChannel(PaymentChannelRequest request) throws Exception {
        this.headerValidation();
        if (request.getMiniAppId() <= 0L) {
            throw new IllegalArgumentException("miniAppId is invalid");
        }
        if (request.getMethod() == null) {
            throw new IllegalArgumentException("method should not be blank");
        }
        Map<String, Object> formData = PartnerClient.getPaymentChannelFormData(request);
        String rsp = this.sendMultipartRequest(this.getBaseUrl(request.getMiniAppId(), EndPoint.PAYMENT_CHANNELS, new int[0]), formData, null, null);
        return JsonUtils.fromJson(rsp, CreatePaymentChannelResponse.class);
    }

    public UpdatePaymentChannelResponse updatePaymentChannel(PaymentChannelRequest request) throws Exception {
        this.headerValidation();
        if (request.getMiniAppId() <= 0L) {
            throw new IllegalArgumentException("miniAppId is invalid");
        }
        if (request.getChannelId() <= 0) {
            throw new IllegalArgumentException("channelId is invalid");
        }
        Map<String, Object> formData = PartnerClient.getPaymentChannelFormData(request);
        String rsp = this.sendMultipartPutRequest(this.getBaseUrl(request.getMiniAppId(), EndPoint.PAYMENT_CHANNELS, request.getChannelId()), null, formData, null);
        return JsonUtils.fromJson(rsp, UpdatePaymentChannelResponse.class);
    }

    public PaymentSettingResponse getPaymentSetting(PaymentSettingRequest request) throws Exception {
        this.headerValidation();
        if (request.getMiniAppId() <= 0L) {
            throw new IllegalArgumentException("miniAppId is invalid");
        }
        String rsp = this.sendHttpGetRequest(this.getBaseUrl(request.getMiniAppId(), EndPoint.PAYMENT_SETTING, new int[0]), null, null);
        return JsonUtils.fromJson(rsp, PaymentSettingResponse.class);
    }

    public UpdatePaymentSettingResponse updatePaymentSetting(UpdatePaymentSettingRequest request) throws Exception {
        this.headerValidation();
        if (request.getMiniAppId() <= 0L) {
            throw new IllegalArgumentException("miniAppId is invalid");
        }
        JsonObject data = new JsonObject();
        data.addProperty("callbackUrl", request.getCallbackUrl());
        data.addProperty("sandboxCallbackUrl", request.getSandboxCallbackUrl());
        data.addProperty("status", request.getStatus().name());
        String rsp = this.sendHttpPutRequest(this.getBaseUrl(request.getMiniAppId(), EndPoint.PAYMENT_SETTING, new int[0]), null, data, null);
        return JsonUtils.fromJson(rsp, UpdatePaymentSettingResponse.class);
    }

    private static Map<String, Object> getPaymentChannelFormData(PaymentChannelRequest request) {
        String thumbnail;
        Map<String, Object> formData = JsonUtils.toMap(request);
        if (request instanceof CustomPaymentChannel && !(thumbnail = (String)formData.getOrDefault("thumbnail", "")).isEmpty()) {
            formData.put("thumbnail", new File(thumbnail));
        }
        return formData;
    }

    public CreateQRCodeShortUrlResponse createQRCodeShortUrl(CreateQRCodeShortUrlRequest request) throws Exception {
        this.headerValidation();
        if (request.getMiniAppId() <= 0L) {
            throw new IllegalArgumentException("miniAppId is invalid");
        }
        if (request.getOriginalUrl() == null || request.getOriginalUrl().isEmpty()) {
            throw new IllegalArgumentException("originalUrl should not be blank");
        }
        JsonObject data = new JsonObject();
        data.addProperty("originUrl", request.getOriginalUrl());
        String rsp = this.sendHttpPostRequest(this.getBaseUrl(request.getMiniAppId(), EndPoint.QRCODE_SHORT_LINKS, new int[0]), null, data, null);
        return JsonUtils.fromJson(rsp, CreateQRCodeShortUrlResponse.class);
    }

    public ListQRCodeShortLinkResponse listQRCodeShortLink(ListQRCodeShortLinkRequest request) throws Exception {
        this.headerValidation();
        if (request.getMiniAppId() <= 0L) {
            throw new IllegalArgumentException("miniAppId is invalid");
        }
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("offset", String.valueOf(request.getOffset()));
        params.put("limit", String.valueOf(request.getLimit()));
        String rsp = this.sendHttpGetRequest(this.getBaseUrl(request.getMiniAppId(), EndPoint.QRCODE_SHORT_LINKS, new int[0]), params, null);
        return JsonUtils.fromJson(rsp, ListQRCodeShortLinkResponse.class);
    }

    public ListApiDomainResponse listAPIDomain(ListApiDomainRequest request) throws Exception {
        this.headerValidation();
        if (request.getMiniAppId() <= 0L) {
            throw new IllegalArgumentException("miniAppId is invalid");
        }
        String rsp = this.sendHttpGetRequest(this.getBaseUrl(request.getMiniAppId(), EndPoint.API_DOMAINS, new int[0]), null, null);
        return JsonUtils.fromJson(rsp, ListApiDomainResponse.class);
    }

    public CreateApiDomainResponse createApiDomain(CreateApiDomainRequest request) throws Exception {
        this.headerValidation();
        if (request.getMiniAppId() <= 0L) {
            throw new IllegalArgumentException("miniAppId is invalid");
        }
        JsonObject data = new JsonObject();
        data.addProperty("domain", request.getDomain());
        data.addProperty("status", request.getStatus());
        data.addProperty("miniAppId", request.getMiniAppId());
        String rsp = this.sendHttpPostRequest(this.getBaseUrl(request.getMiniAppId(), EndPoint.API_DOMAINS, new int[0]), null, data, null);
        return JsonUtils.fromJson(rsp, CreateApiDomainResponse.class);
    }

    public UpdateApiDomainResponse updateApiDomain(UpdateApiDomainRequest request) throws Exception {
        this.headerValidation();
        if (request.getMiniAppId() <= 0L) {
            throw new IllegalArgumentException("miniAppId is invalid");
        }
        JsonObject data = new JsonObject();
        data.addProperty("status", request.getStatus());
        data.addProperty("miniAppId", request.getMiniAppId());
        data.addProperty("id", request.getId());
        String rsp = this.sendHttpPutRequest(this.getBaseUrl(request.getMiniAppId(), EndPoint.API_DOMAINS, new int[0]), null, data, null);
        return JsonUtils.fromJson(rsp, UpdateApiDomainResponse.class);
    }

    public AppInfoResponse getAppInfo(AppInfoRequest request) throws Exception {
        this.headerValidation();
        if (request.getMiniAppId() <= 0L) {
            throw new IllegalArgumentException("miniAppId is invalid");
        }
        String responseString = this.sendHttpGetRequest(this.getBaseUrl(request.getMiniAppId(), EndPoint.APP_INFO, new int[0]), null, null);
        return JsonUtils.fromJson(responseString, AppInfoResponse.class);
    }

    public ValidateNameResponse validateName(ValidateNameRequest request) throws Exception {
        this.headerValidation();
        if (request.getName() == null || request.getName().isEmpty()) {
            throw new IllegalArgumentException("name should not be blank");
        }
        JsonObject data = new JsonObject();
        data.addProperty("name", request.getName());
        String responseString = this.sendHttpPostRequest(this.getBaseUrl(null, EndPoint.VALIDATE_NAME, new int[0]), null, data, null);
        ValidateNameResponse response = JsonUtils.fromJson(responseString, ValidateNameResponse.class);
        response.setValid(response.getError() >= 0);
        return response;
    }

    public BusinessProfileResponse getBusinessProfile(BusinessProfileRequest request) throws Exception {
        this.headerValidation();
        if (request.getMiniAppId() <= 0L) {
            throw new IllegalArgumentException("miniAppId is invalid");
        }
        String responseString = this.sendHttpGetRequest(this.getBaseUrl(request.getMiniAppId(), EndPoint.BUSINESS_PROFILE, new int[0]), null, null);
        return JsonUtils.fromJson(responseString, BusinessProfileResponse.class);
    }

    public UpdateAppCategoryResponse updateAppCategory(UpdateAppCategoryRequest request) throws Exception {
        this.headerValidation();
        if (request.getMiniAppId() <= 0L) {
            throw new IllegalArgumentException("miniAppId is invalid");
        }
        if (request.getCategory() == null || request.getCategory().isEmpty()) {
            throw new IllegalArgumentException("category is required");
        }
        if (request.getSubCateIds() == null || request.getSubCateIds().isEmpty()) {
            throw new IllegalArgumentException("subCateIds is required");
        }
        JsonObject data = new JsonObject();
        data.addProperty("category", request.getCategory());
        JsonArray subCateIdsArray = new JsonArray();
        for (Integer id : request.getSubCateIds()) {
            subCateIdsArray.add(id);
        }
        data.add("subCateIds", subCateIdsArray);
        String rsp = this.sendHttpPutRequest(this.getBaseUrl(request.getMiniAppId(), EndPoint.APP_INFO, new int[0]), null, data, null);
        return JsonUtils.fromJson(rsp, UpdateAppCategoryResponse.class);
    }

    public DocumentsResponse getDocuments(DocumentsRequest request) throws Exception {
        this.headerValidation();
        if (request.getMiniAppId() <= 0L) {
            throw new IllegalArgumentException("miniAppId is invalid");
        }
        String responseString = this.sendHttpGetRequest(this.getBaseUrl(request.getMiniAppId(), "/document-request", new int[0]), null, null);
        return JsonUtils.fromJson(responseString, DocumentsResponse.class);
    }

    public UploadDocumentFileResponse uploadDocumentFile(UploadDocumentFileRequest request) throws Exception {
        this.headerValidation();
        if (request.getMiniAppId() <= 0L) {
            throw new IllegalArgumentException("miniAppId is invalid");
        }
        if (request.getFile() == null || !request.getFile().exists()) {
            throw new IllegalArgumentException("file is invalid or does not exist");
        }
        HashMap<String, File> files = new HashMap<String, File>();
        files.put("file", request.getFile());
        String responseString = this.sendHttpUploadRequest(this.getBaseUrl(request.getMiniAppId(), "/document-file", new int[0]), files, null, null);
        return JsonUtils.fromJson(responseString, UploadDocumentFileResponse.class);
    }

    public SubmitBusinessDocumentsResponse submitBusinessDocuments(SubmitBusinessDocumentsRequest request) throws Exception {
        this.headerValidation();
        if (request.getMiniAppId() <= 0L) {
            throw new IllegalArgumentException("miniAppId is invalid");
        }
        if (request.getBusinessDocuments() == null || request.getBusinessDocuments().isEmpty()) {
            throw new IllegalArgumentException("businessDocuments should not be empty");
        }
        JsonObject data = new JsonObject();
        JsonArray businessDocumentsArray = new JsonArray();
        for (SubmitBusinessDocumentsRequest.BusinessDocument doc : request.getBusinessDocuments()) {
            JsonObject docObject = new JsonObject();
            docObject.addProperty("fileId", doc.getFileId());
            docObject.addProperty("fileName", doc.getFileName());
            if (doc.getType() != null && !doc.getType().isEmpty()) {
                docObject.addProperty("type", doc.getType());
            }
            if (doc.getDocumentTypeId() != null) {
                docObject.addProperty("documentTypeId", doc.getDocumentTypeId());
            } else if (doc.getDocumentType() != null) {
                docObject.addProperty("documentType", doc.getDocumentType());
            }
            docObject.addProperty("subCategoryId", doc.getSubCategoryId());
            businessDocumentsArray.add(docObject);
        }
        data.add("businessDocuments", businessDocumentsArray);
        String responseString = this.sendHttpPostRequest(this.getBaseUrl(request.getMiniAppId(), "/business-document-request", new int[0]), null, data, null);
        return JsonUtils.fromJson(responseString, SubmitBusinessDocumentsResponse.class);
    }

    public SubmitOwnerDocumentsResponse submitOwnerDocuments(SubmitOwnerDocumentsRequest request) throws Exception {
        this.headerValidation();
        if (request.getMiniAppId() <= 0L) {
            throw new IllegalArgumentException("miniAppId is invalid");
        }
        HashMap<String, byte[]> files = new HashMap<String, byte[]>();
        HashMap<String, String> params = new HashMap<String, String>();
        if (request.getOwnerDocumentFiles() != null) {
            int index = 0;
            for (DocumentFile documentFile : request.getOwnerDocumentFiles()) {
                if (documentFile.getFile() == null) continue;
                files.put("ownerDocumentFiles[" + index + "]_File", documentFile.getFile());
                if (documentFile.getName() != null && !documentFile.getName().isEmpty()) {
                    params.put("ownerDocumentFiles[" + index + "]_File", documentFile.getName());
                }
                if (documentFile.getDocumentType() != null && !documentFile.getDocumentType().isEmpty()) {
                    JsonObject metadata = new JsonObject();
                    metadata.addProperty("documentType", documentFile.getDocumentType());
                    if (documentFile.getSubCategoryId() != null) {
                        metadata.addProperty("subCategoryId", documentFile.getSubCategoryId());
                    }
                    params.put("ownerDocumentFiles[" + index + "]_Meta", metadata.toString());
                }
                ++index;
            }
        }
        if (request.getDocumentFiles() != null) {
            JsonArray documentFilesArray = new JsonArray();
            for (DocumentInfo documentInfo : request.getDocumentFiles()) {
                JsonObject docInfo = new JsonObject();
                docInfo.addProperty("documentType", documentInfo.getDocumentType());
                docInfo.addProperty("name", documentInfo.getName());
                docInfo.addProperty("url", documentInfo.getUrl());
                docInfo.addProperty("type", "OWNER_LICENSE");
                if (documentInfo.getSubCategoryId() != null) {
                    docInfo.addProperty("subCategoryId", documentInfo.getSubCategoryId());
                }
                documentFilesArray.add(docInfo);
            }
            params.put("documentFiles", documentFilesArray.toString());
        }
        String responseString = this.sendHttpUploadByteRequest(this.getBaseUrl(request.getMiniAppId(), "/owner-document-request", new int[0]), files, params, null);
        return JsonUtils.fromJson(responseString, SubmitOwnerDocumentsResponse.class);
    }

    public ValidateOAResponse validateOA(ValidateOARequest request) throws Exception {
        this.headerValidation();
        if (request.getMiniAppId() <= 0L || request.getOaId() <= 0L) {
            throw new IllegalArgumentException("miniappId and oaId should not be blank");
        }
        JsonObject data = new JsonObject();
        data.addProperty("oaId", request.getOaId());
        data.addProperty("userId", request.getUserId());
        String responseString = this.sendHttpPostRequest(this.getBaseUrl(request.getMiniAppId(), EndPoint.VALIDATE_OA, new int[0]), null, data, null);
        ValidateOAResponse response = JsonUtils.fromJson(responseString, ValidateOAResponse.class);
        return response;
    }

    public VerifyOAResponse verifyOA(VerifyOARequest request) throws Exception {
        this.headerValidation();
        if (request.getMiniAppId() <= 0L) {
            throw new IllegalArgumentException("miniAppId is invalid");
        }
        JsonObject data = new JsonObject();
        data.addProperty("oaId", request.getOaId());
        String responseString = this.sendHttpPostRequest(this.getBaseUrl(request.getMiniAppId(), EndPoint.VERIFY_OA, new int[0]), null, data, null);
        return JsonUtils.fromJson(responseString, VerifyOAResponse.class);
    }

    public UpdateBusinessProfileResponse updateBusinessProfile(UpdateBusinessProfileRequest request) throws Exception {
        this.headerValidation();
        if (request.getMiniAppId() <= 0L) {
            throw new IllegalArgumentException("miniAppId is invalid");
        }
        JsonObject data = new JsonObject();
        if (request.getTypeOfBusiness() != null) {
            data.addProperty("typeOfBusiness", request.getTypeOfBusiness());
        }
        if (request.getKybData() != null) {
            data.addProperty("kybData", request.getKybData());
        }
        String rsp = this.sendHttpPutRequest(this.getBaseUrl(request.getMiniAppId(), EndPoint.BUSINESS_PROFILE, new int[0]), null, data, null);
        return JsonUtils.fromJson(rsp, UpdateBusinessProfileResponse.class);
    }

    public ListPermitsResponse listPermits(ListPermitsRequest request) throws Exception {
        JsonObject dataResponse;
        this.headerValidation();
        if (request.getCategoryId() == null || request.getCategoryId().isEmpty()) {
            throw new IllegalArgumentException("categoryId should not be blank");
        }
        JsonObject data = new JsonObject();
        if (request.getMiniAppId() > 0L) {
            data.addProperty("appId", request.getMiniAppId());
        }
        data.addProperty("categoryId", request.getCategoryId());
        if (request.getSubCategoryIds() != null && !request.getSubCategoryIds().isEmpty()) {
            JsonArray subCategoryIdsArray = new JsonArray();
            for (Integer id : request.getSubCategoryIds()) {
                subCategoryIdsArray.add(id);
            }
            data.add("subCategoryIds", subCategoryIdsArray);
        }
        String responseString = this.sendHttpPostRequest(this.getBaseUrl(null, EndPoint.PERMITS, new int[0]), null, data, null);
        JsonObject jsonObject = JsonUtils.fromJson(responseString, JsonObject.class);
        ListPermitsResponse response = new ListPermitsResponse();
        if (jsonObject == null) {
            response.setError(-1);
            response.setMessage("Invalid response from server");
            return response;
        }
        if (jsonObject.get("err") != null) {
            response.setError(jsonObject.get("err").getAsInt());
        } else {
            response.setError(-1);
        }
        if (jsonObject.get("msg") != null) {
            response.setMessage(jsonObject.get("msg").getAsString());
        } else {
            response.setMessage("Unknown error");
        }
        if (response.getError() == 0 && jsonObject.has("data") && (dataResponse = jsonObject.getAsJsonObject("data")) != null && dataResponse.has("permits")) {
            response.setPermits(JsonUtils.fromJSONArray(dataResponse.getAsJsonArray("permits"), ListPermitsResponse.PermitCategory.class));
        }
        return response;
    }
}

