/*
 * Decompiled with CFR 0.152.
 */
package com.vng.zalo.miniapp.openapi.sdk.utils;

import com.google.gson.JsonObject;
import java.math.BigInteger;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Collections;

public class VerifySignature {
    public static String generateSignature(JsonObject data, String apiKey) throws NoSuchAlgorithmException {
        if (data == null || data.get("timestamp").getAsLong() < 0L) {
            return null;
        }
        ArrayList<String> keys = new ArrayList<String>(data.keySet());
        Collections.sort(keys);
        StringBuilder content = new StringBuilder();
        for (String key : keys) {
            content.append(data.get(key).getAsString());
        }
        return VerifySignature.getSHA256(content.toString() + apiKey);
    }

    public static String getSHA256(String input) throws NoSuchAlgorithmException {
        MessageDigest md = MessageDigest.getInstance("SHA-256");
        byte[] messageDigest = md.digest(input.getBytes());
        BigInteger no = new BigInteger(1, messageDigest);
        StringBuilder hashText = new StringBuilder(no.toString(16));
        while (hashText.length() < 64) {
            hashText.insert(0, "0");
        }
        return hashText.toString();
    }
}

